% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autonames.R
\name{autonames}
\alias{autonames}
\title{Automatically generate names for vectors}
\usage{
autonames(x, ..., trimws = TRUE)
}
\arguments{
\item{x}{A vector}

\item{...}{Additional arguments passed to \code{\link[=format]{format()}}}

\item{trimws}{Whether to trim whitespace surrounding automatically formatted
names.
Defaults to \code{TRUE}.}
}
\value{
Returns the names of a named vector and the elements of an unnamed
vector formatted as characters.
}
\description{
Automatically generate names for vectors
}
\examples{
autonames(c(a = "apple", b = "banana", c = "cantaloupe"))
autonames(c("apple", "banana", "cantaloupe"))

autonames(10^(1:4))
autonames(10^(1:4), big.mark = ",")
autonames(10^(1:4), scientific = TRUE)
}
