% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mid_dotplot.R
\name{build_mid_dotplot}
\alias{build_mid_dotplot}
\title{Middle MG/hap dot plot}
\usage{
build_mid_dotplot(HapObject, epsilon, hide_labels = FALSE)
}
\arguments{
\item{HapObject}{Haplotype object created by run_haplotyping}

\item{epsilon}{Epsilon to visualize haplotyping results for.}

\item{hide_labels}{If TRUE, legend is hidden.}
}
\value{
A ggplot2 object.
}
\description{
build_mid_dotplot() builds a central dot plot displaying the relationship
between haplotype combinations and the characteristic marker group alleles
that define them. Makes use of the $Hapfile information from a haplotype
object. This is an internal function called by crosshap_viz(), though can
be called separately to build a stand-alone plot (can be useful when patched
to a peripheral plot).
}
\examples{
build_mid_dotplot(HapObject, epsilon = 0.6, hide_labels = FALSE)

}
