% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration_tmax_and_tmin.R
\name{tmin_calibration}
\alias{tmin_calibration}
\title{Calibration of minimum air temperature from TerraClimate}
\usage{
tmin_calibration(slope, intercept, tmin_stack)
}
\arguments{
\item{slope}{the slope of the linear regression (numeric)}

\item{intercept}{the intercept of the linear regression (numeric)}

\item{tmin_stack}{stack of maximum air temperature}
}
\value{
Returns a Rasterstack of calibrated minimum air temperature.
}
\description{
This fuction will calibrate the minimum air temperature from TerraClimate dataset based in the relationship with observed weather stations data. The values of slope and intercept informed in example correspond a calibration performed between 'Terraclimate' images and INMET automatic weather stations realized for all the brazilian territory.
}
\examples{
\dontrun{
tmin_cal<- tmin_calibrated(slope = 0.830652, intercept = 4.187840, tmin_stack = tmin);
}
}
