% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reciprocal_space.R
\name{invfousynth}
\alias{invfousynth}
\title{From density to structure factors using inverse Fourier synthesis}
\usage{
invfousynth(a, rho, hidx)
}
\arguments{
\item{a}{A real number. The unit cell side length.}

\item{rho}{A vector of N real numbers representing the 1D density at
each of the regular N grid point.}

\item{hidx}{A vector of integer numbers. The set of 1D Miller indices
corresponding to the set of structure factors F, to be calculated.}
}
\value{
A vector of N real numbers representing the calculated 1D 
   density at each one of the regular N grid points.
}
\description{
Given a density as vector calculated in N grid points, the unit cell
size and an array of Miller indices hidx, this function calculates
amplitudes and phases of the structure factors corresponding to this
density, via inverse Fourier transform.
}
\examples{
# First create the crystal structure (in P1)
a <- 10
SG <- "P1"
x0 <- c(1,4,6.5)
Z <- c(8,26,6)
B <- c(18,20,17)
occ <- c(1,1,1)
sdata <- standardise_sdata(a,SG,x0,Z,B,occ)

# 10 Miller indices plus DC component
hidx <- 0:10

# Compute structure factors
ftmp1 <- strufac(hidx,sdata)

# Number of grid points
N <- 1000

# Density
rtmp <- fousynth(a,ftmp1$Fmod,ftmp1$Fpha,hidx,N)

# Using inverse Fourier to obtain structure factors
ftmp2 <- invfousynth(a,rtmp$rr,hidx)

# Comparison
print(abs(ftmp1$Fmod-ftmp2$Fmod))
print(abs(ftmp1$Fpha-ftmp2$Fpha))

}
