% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cron_save.R
\name{cron_save}
\alias{cron_save}
\title{Save the current crontab}
\usage{
cron_save(file, overwrite = FALSE, user = "")
}
\arguments{
\item{file}{The file location at which you wish to save your
\code{crontab}.}

\item{overwrite}{logical; should we overwrite the file at path \code{file}
if it already exists?}

\item{user}{The user whose cron jobs we will be saving.}
}
\description{
Save the current crontab
}
\examples{
\dontrun{
cron_add(command = cron_rscript(system.file(package = "cronR", "extdata", "helloworld.R")), 
  frequency = 'minutely', id = 'test1', description = 'My process 1')
cron_save(file="crontab_backup", overwrite=TRUE)
cron_clear()
cron_load(file="crontab_backup")
}
}
\seealso{
\code{\link{file.copy}}
}

