% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crm_links.R
\name{crm_links}
\alias{crm_links}
\title{Get full text links from a DOI}
\usage{
crm_links(doi, type = "all", ...)
}
\arguments{
\item{doi}{(character) A Digital Object Identifier (DOI). required.}

\item{type}{(character) One of 'xml', 'html', 'plain', 'pdf',
'unspecified', or 'all' (default). required.}

\item{...}{Named parameters passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
\code{NULL} if no full text links given; a list of tdmurl objects if
links found.
}
\description{
Get full text links from a DOI
}
\details{
Note that this function is not vectorized.

Some links returned will not in fact lead you to full text
content as you would understandbly think and expect. That is, if you
use the \code{filter} parameter with e.g., \code{\link[rcrossref:cr_works]{rcrossref::cr_works()}}
and filter to only full text content, some links may actually give back
only metadata for an article. Elsevier is perhaps the worst offender,
for one because they have a lot of entries in Crossref TDM, but most
of the links that are apparently full text are not in fact full text,
but only metadata. You can get full text if you are part of a subscribing
institution to that specific Elsever content, but otherwise, you're SOL.

Note that there are still some bugs in the data returned form CrossRef.
For example, for the publisher eLife, they return a single URL with
content-type application/pdf, but the URL is not for a PDF, but for both
XML and PDF, and content-type can be set with that URL as either XML or
PDF to get that type.

In another example, all Elsevier URLs at time of writing are have
\code{http} scheme, while those don't actually work, so we have a
custom fix in this function for that publisher. Anyway, expect changes...
}
\examples{
\dontrun{
data(dois_crminer)

# pdf link
crm_links(doi = "10.5555/515151", "pdf")

# xml and plain text links
crm_links(dois_crminer[1], "pdf")
crm_links(dois_crminer[6], "xml")
crm_links(dois_crminer[7], "plain")
crm_links(dois_crminer[1]) # all is the default

# pdf link
crm_links(doi = "10.5555/515151", "pdf")
crm_links(doi = "10.3897/phytokeys.52.5250", "pdf")

# many calls, use e.g., lapply
lapply(dois_crminer[1:3], crm_links)
}
}
