% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{StoppingTDCIRatio-class}
\alias{StoppingTDCIRatio-class}
\alias{.StoppingTDCIRatio}
\alias{StoppingTDCIRatio}
\alias{.DefaultStoppingTDCIRatio}
\title{\code{StoppingTDCIRatio}}
\usage{
StoppingTDCIRatio(
  target_ratio = 5,
  prob_target = 0.3,
  report_label = NA_character_
)

.DefaultStoppingTDCIRatio()
}
\arguments{
\item{target_ratio}{(\code{numeric})\cr see slot definition.}

\item{prob_target}{(\code{proportion})\cr see slot definition.}

\item{report_label}{(\code{string} or \code{NA})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{StoppingTDCIRatio}} is the class for testing a stopping rule that is based
on a target ratio of the 95\% credibility interval. Specifically, this is the
ratio of the upper to the lower bound of the 95\% credibility interval's
estimate of the target dose (i.e. a dose that corresponds to a given target
probability of the occurrence of a DLT \code{prob_target}).
}
\section{Slots}{

\describe{
\item{\code{target_ratio}}{(\code{numeric})\cr target for the ratio of the 95\% credibility
interval's estimate, that is required to stop a trial.}

\item{\code{prob_target}}{(\code{proportion})\cr the target probability of the occurrence
of a DLT.}
}}

\note{
Typically, end users will not use the \code{.DefaultStoppingTDCIRatio()} function.
}
\examples{
# Define the target stopping ratio (5) and the target probability of a DLT to
# be used (0.3).
my_stopping <- StoppingTDCIRatio(
  target_ratio = 5,
  prob_target = 0.3
)
}
