% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{NextBestMaxGain-class}
\alias{NextBestMaxGain-class}
\alias{.NextBestMaxGain}
\alias{NextBestMaxGain}
\alias{.DefaultNextBestMaxGain}
\title{\code{NextBestMaxGain}}
\usage{
NextBestMaxGain(prob_target_drt, prob_target_eot)

.DefaultNextBestMaxGain()
}
\arguments{
\item{prob_target_drt}{(\code{proportion})\cr see slot definition.}

\item{prob_target_eot}{(\code{proportion})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{NextBestMaxGain}} is the class to find a next best dose with maximum gain
value based on a pseudo DLT and efficacy models without samples. It is based
solely on the probabilities of the occurrence of a DLT and the values
of the mean efficacy responses obtained by using the modal estimates of the
DLT and efficacy model parameters. There are two target probabilities of the
occurrence of a DLT that must be specified: target probability to be used
during the trial and target probability to be used at the end of the trial.
It is suitable to use it only with the \code{\link{ModelTox}} model and \code{\link{ModelEff}}
classes (except \code{\link{EffFlexi}}).
}
\section{Slots}{

\describe{
\item{\code{prob_target_drt}}{(\code{proportion})\cr the target probability of the
occurrence of a DLT to be used during the trial.}

\item{\code{prob_target_eot}}{(\code{proportion})\cr the target probability of the
occurrence of a DLT to be used at the end of the trial.}
}}

\note{
Typically, end users will not use the \code{.DefaultNextBestMaxGain()} function.
}
\examples{
my_next_best <- NextBestMaxGain(0.35, 0.3)
}
