% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{LogisticLogNormalGrouped-class}
\alias{LogisticLogNormalGrouped-class}
\alias{.LogisticLogNormalGrouped}
\alias{LogisticLogNormalGrouped}
\alias{.DefaultLogisticLogNormalGrouped}
\title{\code{LogisticLogNormalGrouped}}
\usage{
LogisticLogNormalGrouped(mean, cov, ref_dose = 1)

.DefaultLogisticLogNormalGrouped()
}
\arguments{
\item{mean}{(\code{numeric})\cr the prior mean vector.}

\item{cov}{(\code{matrix})\cr the prior covariance matrix. The precision matrix
\code{prec} is internally calculated as an inverse of \code{cov}.}

\item{ref_dose}{(\code{number})\cr the reference dose \eqn{x*} (strictly positive
number).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{LogisticLogNormalGrouped}} is the class for a logistic regression model
for both the mono and the combo arms of the simultaneous dose escalation
design.
}
\details{
The continuous covariate is the natural logarithm of the dose \eqn{x} divided by
the reference dose \eqn{x*} as in \code{\link{LogisticLogNormal}}. In addition,
\eqn{I_c} is a binary indicator covariate which is 1 for the combo arm and 0 for the mono arm.
The model is then defined as:
\deqn{logit[p(x)] = (alpha0 + I_c * delta0) + (alpha1 + I_c * delta1) * log(x / x*),}
where \eqn{p(x)} is the probability of observing a DLT for a given dose \eqn{x},
and \code{delta0} and \code{delta1} are the differences in the combo arm compared to the mono intercept
and slope parameters \code{alpha0} and \code{alpha1}.
The prior is defined as \deqn{(alpha0, log(delta0), log(alpha1), log(delta1)) ~ Normal(mean, cov).}
}
\note{
Typically, end users will not use the \code{.DefaultLogisticLogNormalGrouped()} function.
}
\examples{
my_model <- LogisticLogNormalGrouped(
  mean = c(-0.85, 0, 1, 0),
  cov = diag(1, 4),
  ref_dose = 50
)
my_model
}
\seealso{
\code{\link{ModelLogNormal}}, \code{\link{LogisticLogNormal}}.
}
