% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data-methods.R
\name{update,DataParts-method}
\alias{update,DataParts-method}
\title{Update method for the "DataParts" class}
\usage{
\S4method{update}{DataParts}(
  object,
  x,
  y,
  ID = (if (length(object@ID)) max(object@ID) else 0L) + seq_along(y),
  ...
)
}
\arguments{
\item{object}{the old \code{\linkS4class{DataParts}} object}

\item{x}{the dose level (one level only!)}

\item{y}{the DLT vector (0/1 vector), for all patients in this cohort}

\item{ID}{the patient IDs}

\item{\dots}{not used}
}
\value{
the new \code{\linkS4class{DataParts}} object
}
\description{
Add new data to the \code{\linkS4class{DataParts}} object
}
\examples{

# create an object of class 'DataParts'
myData <- DataParts(x=c(0.1,0.5,1.5),
                    y=c(0,0,0),
                    doseGrid=c(0.1,0.5,1.5,3,6,
                               seq(from=10,to=80,by=2)),
                    part=c(1L,1L,1L),
                    nextPart=1L,
                    part1Ladder=c(0.1,0.5,1.5,3,6,10))

# update the data with a new cohort
# to be noted that since we reached the last level from part1Ladder then
# nextPart is switched from '1' to '2'
myData <- update(myData,
                 x=10,
                 y=c(0))


}
\keyword{methods}
