% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/seriesIDFunctions.R
\name{linkage}
\alias{linkage}
\title{Hierarchical Based Linkage}
\usage{
linkage(BF, group, method = c("average", "single", "complete"))
}
\arguments{
\item{BF}{vector of Bayes Factors}

\item{group}{crime group}

\item{method}{the type of linkage for comparing a crime to a set of crimes
  \itemize{
    \item \dQuote{average} uses the average bayes factor
    \item \dQuote{single} uses the largest bayes factor (most similar)
    \item \dQuote{complete} uses the smallest bayes factor (least similar)
  }}
}
\value{
a data.frame of the Bayes Factor scores
   ordered (highest to lowest).
}
\description{
Groups the Bayes Factors by crime group and calculates the linkage score for
  each group.
}
\details{
If methods is a vector of linkages to use, then the all linkages are
   calcualted and ordered according to the first element.
}
\examples{
# See vignette: "Crime Series Identification and Clustering" for usage.
}

