% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_tls.R
\name{crew_tls}
\alias{crew_tls}
\title{Configure TLS.}
\usage{
crew_tls(
  mode = "none",
  key = NULL,
  password = NULL,
  certificates = NULL,
  validate = TRUE
)
}
\arguments{
\item{mode}{Character of length 1. Must be one of the following:
\itemize{
\item \code{"none"}: disable TLS configuration.
\item \code{"automatic"}: let \code{mirai} create a one-time key pair with a
self-signed certificate.
\item \code{"custom"}: manually supply a private key pair, an optional
password for the private key, a certificate,
an optional revocation list.
}}

\item{key}{If \code{mode} is \code{"none"} or \code{"automatic"}, then \code{key} is \code{NULL}.
If \code{mode} is \code{"custom"}, then \code{key} is a character of length 1
with the file path to the private key file.}

\item{password}{If \code{mode} is \code{"none"} or \code{"automatic"},
then \code{password} is \code{NULL}.
If \code{mode} is \code{"custom"} and the private key is not encrypted, then
\code{password} is still \code{NULL}.
If \code{mode} is \code{"custom"} and the private key is encrypted,
then \code{password} is a character of length 1 the the password of the private
key. In this case, DO NOT SAVE THE PASSWORD IN YOUR R CODE FILES.
See the \code{keyring} R package for solutions.}

\item{certificates}{If \code{mode} is \code{"none"} or \code{"automatic"},
then \code{certificates} is \code{NULL}.
If \code{mode} is \code{"custom"}, then \code{certificates} is a character vector
of file paths to certificate files (signed public keys).
If the certificate is self-signed or if it is
directly signed by a certificate authority (CA),
then only the certificate of the CA is needed. But if you have a whole
certificate chain which begins at your own certificate and ends with the
CA, then you can supply the whole certificate chain as a character vector
which begins at your own certificate and ends with
the certificate of the CA.}

\item{validate}{Logical of length 1, whether to validate the configuration
object on creation. If \code{FALSE}, then \code{validate()} can be called later on.}
}
\value{
An \code{R6} object with TLS configuration settings and methods.
}
\description{
Create an \code{R6} object with transport layer security (TLS)
configuration for \code{crew}.
}
\details{
\code{\link[=crew_tls]{crew_tls()}} objects are input to the \code{tls} argument of
\code{\link[=crew_client]{crew_client()}}, \code{\link[=crew_controller_local]{crew_controller_local()}}, etc.
See \url{https://wlandau.github.io/crew/articles/risks.html} for details.
}
\examples{
crew_tls(mode = "automatic")
}
\seealso{
Other tls: 
\code{\link{crew_class_tls}}
}
\concept{tls}
