% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_session_start.R
\name{crew_session_start}
\alias{crew_session_start}
\title{Start a new crew session.}
\usage{
crew_session_start(host = NULL, port = NULL)
}
\arguments{
\item{host}{IP address of the machine hosting the session.
Defaults to the local IP address of the session.}

\item{port}{Positive integer with the port number. Ephemeral
ports between 49152 and 65535 are recommended.
If \code{port} is \code{NULL}, a port will be chosen from
\code{parallelly::freePort()}.}
}
\value{
\code{NULL} (invisibly).
}
\description{
Start a crew session if a session does not already exist.
}
\details{
A \code{crew} session reserves a TCP port with a new NNG socket.
\code{crew} uses this port to monitor the connection statuses of
all workers launched from the current R session across all
controllers and controller groups.
\code{\link[=crew_session_terminate]{crew_session_terminate()}} closes the NNG socket and frees the port.
Be sure to call \code{\link[=crew_session_terminate]{crew_session_terminate()}} when you are finished using
\code{crew} in your R session.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
crew_session_start()
crew_port_get()
crew_port_unset()
}
}
\keyword{session}
