% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_monitor_slurm.R
\name{crew_class_monitor_slurm}
\alias{crew_class_monitor_slurm}
\title{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} SLURM monitor class}
\description{
SLURM monitor \code{R6} class
}
\details{
See \code{\link[=crew_monitor_slurm]{crew_monitor_slurm()}}.
}
\seealso{
Other slurm: 
\code{\link{crew_class_launcher_slurm}},
\code{\link{crew_controller_slurm}()},
\code{\link{crew_launcher_slurm}()},
\code{\link{crew_monitor_slurm}()}
}
\concept{slurm}
\section{Super class}{
\code{\link[crew.cluster:crew_class_monitor_cluster]{crew.cluster::crew_class_monitor_cluster}} -> \code{crew_class_monitor_slurm}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_monitor_slurm-jobs}{\code{crew_class_monitor_slurm$jobs()}}
\item \href{#method-crew_class_monitor_slurm-terminate}{\code{crew_class_monitor_slurm$terminate()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="crew.cluster" data-topic="crew_class_monitor_cluster" data-id="initialize"><a href='../../crew.cluster/html/crew_class_monitor_cluster.html#method-crew_class_monitor_cluster-initialize'><code>crew.cluster::crew_class_monitor_cluster$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew.cluster" data-topic="crew_class_monitor_cluster" data-id="validate"><a href='../../crew.cluster/html/crew_class_monitor_cluster.html#method-crew_class_monitor_cluster-validate'><code>crew.cluster::crew_class_monitor_cluster$validate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_slurm-jobs"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_slurm-jobs}{}}}
\subsection{Method \code{jobs()}}{
List SLURM jobs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_slurm$jobs(user = ps::ps_username())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{Character of length 1, user name of the jobs to list.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This function loads the entire SLURM queue for all users,
so it may take several seconds to execute.
It is intended for interactive use, and
should especially be avoided in scripts where it is called
frequently. It requires SLURM version 20.02 or higher,
along with the YAML plugin.
}

\subsection{Returns}{
A \code{tibble} with one row per SLURM job and columns with
specific details.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_slurm-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_slurm-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate one or more SLURM jobs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_slurm$terminate(jobs = NULL, all = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jobs}}{Character vector of job names or job IDs to terminate.
Ignored if \code{all} is set to \code{TRUE}.}

\item{\code{all}}{Logical of length 1, whether to terminate all the jobs
under your user name. This terminates ALL your SLURM jobs,
regardless of whether \code{crew.cluster} launched them,
so use with caution!}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
