% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{multi_grid}
\alias{multi_grid}
\title{Arrange list of plots into a grid}
\usage{
multi_grid(..., grobs = list(...), nrow = NULL, ncol = NULL)
}
\arguments{
\item{...}{Other parameters.}

\item{grobs}{A list of ggplot-objects to be arranged into the grid.}

\item{nrow}{Number of rows in the plot grid.}

\item{ncol}{Number of columns in the plot grid.}
}
\value{
An object of class \code{gtable}.
}
\description{
Plot multiple ggplot-objects as a grid-arranged single plot.
}
\details{
This function takes a \code{list} of ggplot-objects as argument.
         Plotting functions of this package that produce multiple plot
         objects (e.g., when there is an argument \code{facet.grid}) usually
         return multiple plots as list.
}
\examples{
library(ggplot2)
sub = cv_split(UCICreditCard, k = 30)[[1]]
dat = UCICreditCard[sub,]
dat = re_name(dat, "default.payment.next.month", "target")
dat = data_cleansing(dat, target = "target", obs_id = "ID",
occur_time = "apply_date", miss_values = list("", -1))
dat = process_nas(dat)
train_test <- train_test_split(dat, split_type = "OOT", prop = 0.7,
                                occur_time = "apply_date")
dat_train = train_test$train
dat_test = train_test$test
x_list = c("PAY_0", "LIMIT_BAL", "PAY_AMT5", "PAY_3", "PAY_2")
Formula = as.formula(paste("target", paste(x_list, collapse = ' + '), sep = ' ~ '))
set.seed(46)
lr_model = glm(Formula, data = dat_train[, c("target", x_list)], family = binomial(logit))

dat_train$pred_LR = round(predict(lr_model, dat_train[, x_list], type = "response"), 5)
dat_test$pred_LR = round(predict(lr_model, dat_test[, x_list], type = "response"), 5)
# model evaluation
p1 =  ks_plot(train_pred = dat_train, test_pred = dat_test, target = "target", score = "pred_LR")
p2 =  roc_plot(train_pred = dat_train, test_pred = dat_test, target = "target", score = "pred_LR")
p3 =  lift_plot(train_pred = dat_train, test_pred = dat_test, target = "target", score = "pred_LR")
p4 = score_distribution_plot(train_pred = dat_train, test_pred = dat_test,
target = "target", score = "pred_LR")
p_plots= multi_grid(p1,p2,p3,p4)
plot(p_plots)
}
