% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_exploration.R
\name{data_exploration}
\alias{data_exploration}
\title{Data Exploration}
\usage{
data_exploration(dat, target = NULL, save_data = FALSE,
  file_name = NULL, dir_path = tempdir())
}
\arguments{
\item{dat}{A data.frame with x and target.}

\item{target}{The name of target variable.}

\item{save_data}{Logical. If TRUE, save  files to the specified folder at \code{dir_path}}

\item{file_name}{The file name for periodically saved outliers analysis file. Default is NULL.}

\item{dir_path}{The path for periodically saved outliers analysis file. Default is tempdir().}
}
\value{
A list contains both categrory and numeric variable analysis.
}
\description{
#'The \code{data_exploration} includes both univariate and bivariate analysis and ranges from univariate statistics and frequency distributions, to correlations, cross-tabulation and characteristic analysis.
}
\examples{
data_ex = data_exploration(dat = lendingclub[1:1000,],target = "loan_status")
}
