# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Probability mass function (PMF) of discrete power law
#'
#' \code{dupp} returns the PMF at x for the discrete power law with exponent (1.0 / xi1 + 1.0), for values greater than or equal to u. 
#'
#' The PMF is proportional to x^(-alpha), where alpha = 1.0 / xi1 + 1.0. To be a proper PMF, it is normalised by 1/hzeta(alpha, u), where hzeta is the Hurwitz zeta function i.e. hzeta(y, z) = z^(-y) + (z+1)^(-y) + (z+2)^(-y) + ... Any values below u will have PMF equal to 0.0. That xi1 is used instead of alpha is for alignment with the parametrisation in \code{dmix}, \code{Smix} and \code{mcmc_mix}.
#' @param x Vector of positive integers
#' @param u Scalar, non-negative integer threshold
#' @param xi1 Scalar, a positive real number representing the shape parameter
#' @param log Boolean (default 'FALSE'), whether the PMF should be returned on the log scale.
#' @return A numeric vector of the same length as x
#' @examples
#' dupp(c(10,20,30,40,50), 12, 2.0, FALSE)
#' dupp(c(10,20,30,40,50), 12, 2.0, TRUE)
#' @seealso \code{\link{Supp}} for the corresponding survival function, \code{\link{dmix}} for the PMF of the discrete extreme value mixture distribution.
#' @export
dupp <- function(x, u, xi1, log = FALSE) {
    .Call(`_crandep_dupp`, x, u, xi1, log)
}

#' Survival function of discrete power law
#'
#' \code{Supp} returns the survival function at x for the discrete power law with exponent (1.0 / xi1 + 1.0), for values greater than or equal to u.
#'
#' The survival function used is S(x) = Pr(X >= x), where X is a random variable following the discrete power law. The inclusion of x in the sum means S(x) may not necessarily equal to Pr(X > x) as the distribution is discrete. In the case of discrete power law, it can be shown that S(x) = hzeta(alpha, x)/hzeta(alpha, u), where hzeta is the Hurwitz zeta function i.e. hzeta(y, z) = z^(-y) + (z+1)^(-y) + (z+2)^(-y) + ... and alpha = 1.0 / xi1 + 1.0. That xi1 is used instead of alpha is for alignment with the parametrisation in \code{dmix}, \code{Smix} and \code{mcmc_mix}.
#' @param x Vector of positive integers
#' @param u Scalar, non-negative integer threshold
#' @param xi1 Scalar, a positive real number representing the shape parameter
#' @param log Boolean (default 'FALSE'), whether the survival function should be returned on the log scale.
#' @return A numeric vector of the same length as x
#' @examples
#' Supp(c(10,20,30,40,50), 12, 2.0)
#' @seealso \code{\link{dupp}} for the corresponding probability mass function, \code{\link{Smix}} for the survival function of the discrete extreme value mixture distribution.
#' @export
Supp <- function(x, u, xi1, log = FALSE) {
    .Call(`_crandep_Supp`, x, u, xi1, log)
}

#' Markov chain Monte Carlo for discrete power law
#'
#' \code{mcmc_upp} returns the samples from the posterior of xi1, for fitting the discrete power law to the data x. The samples are obtained using Markov chain Monte Carlo (MCMC).
#'
#' In the MCMC, a componentwise Metropolis-Hastings algorithm is used. Unlike \code{mcmc_mix}, the threshold u is treated as fixed in \code{mcmc_upp}.
#' @param x Vector of positive integers, representing the data
#' @param u Scalar, non-negative integer threshold
#' @param xi1 Scalar, initial value of the shape parameter
#' @param a_xi1 Scalar, lower bound of the uniform distribution as the prior of xi1
#' @param b_xi1 Scalar, upper bound of the uniform distribution as the prior of xi1
#' @param N Scalar, positive integer representing the length of the output chain i.e. the number of rows in the returned data frame
#' @param thin Scalar, positive integer representing the thinning in the MCMC
#' @param burnin Scalar, non-negative integer representing the burn-in of the MCMC
#' @param print_freq Scalar, positive integer representing the frequency of printing the sampled values
#' @return A data frame containing N rows and 2 columns which represent xi1 and the log-posterior density (lpost)
#' @seealso \code{\link{mcmc_mix}} for MCMC for the discrete extreme value mixture distribution.
#' @export
mcmc_upp <- function(x, u, xi1, a_xi1, b_xi1, N = 20000L, thin = 10L, burnin = 20000L, print_freq = 10000L) {
    .Call(`_crandep_mcmc_upp`, x, u, xi1, a_xi1, b_xi1, N, thin, burnin, print_freq)
}

#' Probability mass function (PMF) of discrete extreme value mixture distribution
#'
#' \code{dmix} returns the PMF at x for the discrete extreme value mixture distribution.
#' @param x Vector of positive integers
#' @param u Scalar, positive integer threshold
#' @param xi1 Scalar, shape parameter for values below or equal to u
#' @param xi2 Scalar, shape parameter of integer generalised Pareto distribution (IGPD), for values above u
#' @param sig Scalar, scale parameter of IGPD, for values above u
#' @param geo Boolean. If 'TRUE', the geometric distribution is used for the values below u. If 'FALSE', the discrete power law is used.
#' @param phi Scalar, exceedance probability of u, between 0.0 and 1.0 exclusive
#' @param log Boolean (default 'FALSE'), whether the PMF should be returned on the log scale.
#' @return A numeric vector of the same length as x
#' @examples
#' dmix(10:15, 12, 2.0, 0.5, 1.0, TRUE, 0.2)
#' dmix(10:15, 12, 2.0, 0.5, 1.0, FALSE, 0.2)
#' dmix(10:15, 12, 2.0, 0.5, 1.0, FALSE, 0.2, TRUE)
#' @seealso \code{\link{Smix}} for the corresponding survival function, \code{\link{dupp}} for the probability mass function of the discrete power law.
#' @export
dmix <- function(x, u, xi1, xi2, sig, geo, phi, log = FALSE) {
    .Call(`_crandep_dmix`, x, u, xi1, xi2, sig, geo, phi, log)
}

#' Survival function of discrete extreme value mixture distribution
#'
#' \code{Smix} returns the survival function at x for the discrete extreme value mixture distribution.
#' @param x Vector of positive integers
#' @param u Scalar, positive integer threshold
#' @param xi1 Scalar, shape parameter for values below or equal to u
#' @param xi2 Scalar, shape parameter of integer generalised Pareto distribution (IGPD), for values above u
#' @param sig Scalar, scale parameter of IGPD, for values above u
#' @param geo Boolean. If 'TRUE', the geometric distribution is used for the values below u. If 'FALSE', the discrete power law is used.
#' @param phi Scalar, exceedance probability of u, between 0.0 and 1.0 exclusive
#' @param log Boolean (default 'FALSE'), whether the survival function should be returned on the log scale.
#' @return A numeric vector of the same length as x
#' @examples
#' Smix(10:15, 12, 2.0, 0.5, 1.0, TRUE, 0.2)
#' Smix(10:15, 12, 2.0, 0.5, 1.0, FALSE, 0.2)
#' @seealso \code{\link{dmix}} for the corresponding probability mass function, \code{\link{Supp}} for the survival function of the discrete power law.
#' @export
Smix <- function(x, u, xi1, xi2, sig, geo, phi, log = FALSE) {
    .Call(`_crandep_Smix`, x, u, xi1, xi2, sig, geo, phi, log)
}

#' Markov chain Monte Carlo for discrete extreme value mixture distribution
#'
#' \code{mcmc_mix} returns the samples from the joint posterior of the parameters (u, xi1, xi2, sig), for fitting the discrete extreme value mixture distribution (DEVMD) to the data x. The samples are obtained using Markov chain Monte Carlo (MCMC).
#'
#' In the MCMC, a componentwise Metropolis-Hastings algorithm is used. Unlike \code{mcmc_upp}, the threshold u is treated as a parameter in \code{mcmc_mix} and therefore inferred. The 8 hyperparameters are used in the following priors: u is such that the implied exceedance probability phi ~ Uniform(a_phi, b_phi); xi1 ~ Uniform(a_xi1, b_xi1); xi2 ~ Normal(mean = m_xi2, sd = s_xi2); sig ~ Gamma(shape = a_sig, rate = b_sig). If pcont = 0.0, only the unconstrained version of the DEVMD is fitted; if pcont = 1.0, only the continuity constrained version is fitted. Setting pcont between 0.0 and 1.0 allows both versions to be fitted, if model selection between the two is of interest.
#' @param x Vector of positive integers, representing the data
#' @param u Scalar, initial value of the positive integer threshold
#' @param xi1 Scalar, initial value of the parameter for values below or equal to u
#' @param xi2 Scalar, initial value of the shape parameter of the integer generalised Pareto distribution (IGPD), for values above u
#' @param sig Scalar, initial value of the scale parameter of IGPD, for values above u
#' @param geo Boolean. If 'TRUE', the geometric distribution is used for the values below u. If 'FALSE', the discrete power law is used.
#' @param cont Boolean, whether the continuity constraint is imposed at u
#' @param a_phi,b_phi,a_xi1,b_xi1,m_xi2,s_xi2,a_sig,b_sig Scalars, representing the hyperparameters of the prior distributions of the respective parameters. See details for the specification of the priors.
#' @param pcont Scalar, between 0.0 and 1.0, representing the prior probability of the continuity constrained version, for model selection.
#' @param N Scalar, positive integer representing the length of the output chain i.e. the number of rows in the returned data frame
#' @param thin Scalar, positive integer representing the thinning in the MCMC
#' @param burnin Scalar, non-negative integer representing the burn-in of the MCMC
#' @param print_freq Scalar, positive integer representing the frequency of printing the sampled values
#' @return A data frame containing N rows and 7 columns which represent (in this order) the 4 parameters (u, xi1, xi2, sig), the implied exceedance probability (phi), the log-posterior density (lpost), and whether the continuity constraint is imposed (cont).
#' @seealso \code{\link{mcmc_upp}} for MCMC for the discrete power law.
#' @export
mcmc_mix <- function(x, u, xi1, xi2, sig, geo, cont, a_phi, b_phi, a_xi1, b_xi1, m_xi2, s_xi2, a_sig, b_sig, pcont, N = 20000L, thin = 100L, burnin = 20000L, print_freq = 10000L) {
    .Call(`_crandep_mcmc_mix`, x, u, xi1, xi2, sig, geo, cont, a_phi, b_phi, a_xi1, b_xi1, m_xi2, s_xi2, a_sig, b_sig, pcont, N, thin, burnin, print_freq)
}

