% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_predict.R
\name{model_predict}
\alias{model_predict}
\title{Cram Policy: Predict with the Specified Model}
\usage{
model_predict(model, X, D, model_type, learner_type, model_params)
}
\arguments{
\item{model}{A trained model object returned by the `fit_model` function.}

\item{X}{A matrix or data frame of covariates for which predictions are required.}

\item{D}{A vector of binary treatment indicators (1 for treated, 0 for untreated). Optional, depending on the model type.}

\item{model_type}{The model type for policy learning. Options include \code{"causal_forest"}, \code{"s_learner"}, and \code{"m_learner"}. Default is \code{"causal_forest"}.}

\item{learner_type}{The learner type for the chosen model. Options include \code{"ridge"} for Ridge Regression and \code{"fnn"} for Feedforward Neural Network. Default is \code{"ridge"}.}

\item{model_params}{A list of additional parameters to pass to the model, which can be any parameter defined in the model reference package. Defaults to \code{NULL}.}
}
\value{
A vector of binary policy assignments, depending on the \code{model_type} and \code{learner_type}.
}
\description{
This function performs inference using a trained model, providing flexibility for different types of models
such as Causal Forest, Ridge Regression, and Feedforward Neural Networks (FNNs).
}
