% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibullfns.R
\name{weib_memsim}
\alias{weib_memsim}
\title{Memoryless simulation for the Weibull change-point hazard distribution}
\usage{
weib_memsim(n, endtime, gamma, theta, tau = NA)
}
\arguments{
\item{n}{Sample size}

\item{endtime}{Maximum study time, point at which all participants
are censored}

\item{gamma}{Shape parameter \eqn{\gamma}}

\item{theta}{Scale parameter \eqn{\theta}}

\item{tau}{Change-point(s) \eqn{\tau}}
}
\value{
Dataset with n participants including a survival time
and censoring indicator (0 = censored, 1 = event).
}
\description{
\code{weib_memsim} simulates time-to-event data from the Weibull change-point
hazard distribution by implementing the memoryless method.
}
\details{
This function simulates time-to-event data between \eqn{K} change-points \eqn{\tau}
from independent Weibull distributions using the inverse Weibull CDF
implemented in \code{\link{weib_icdf}}. This method applies Type I right
censoring at the endtime specified by the user. \eqn{\gamma} is
held constant.
}
\examples{
nochangepoint <- weib_memsim(n = 10, endtime = 20, gamma = 2,
  theta = 0.05)
onechangepoint <- weib_memsim(n = 10, endtime = 20, gamma = 2,
  theta = c(0.05, 0.01), tau = 10)
twochangepoints <- weib_memsim(n = 10, endtime = 20, gamma = 2,
  theta = c(0.05, 0.01, 0.05), tau = c(8, 12))

}
