% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influence_weights.R
\name{influence_weights}
\alias{influence_weights}
\title{Influence Weights}
\usage{
influence_weights(
  x,
  p = 2,
  margin = seq_along(x$bspline_list),
  n_polycoef = 20L
)
}
\arguments{
\item{x}{a \code{cpr_cp} or \code{cpr_cn} object}

\item{p}{the order of the norm, default \code{p = 2}.}

\item{margin}{The margins to apply CNR to.  Ignored for \code{cpr_cp}
objects.}

\item{n_polycoef}{for influence weights in tensor products, this parameter
set the number of polynomial coefficients to use in each of the marginal
calculations.  Ignored for \code{cpr_cp} objects.}
}
\value{
A \code{data.frame} with two elements, the internal knots (iknots) and the weights.
}
\description{
Determine the influence weight of each internal knot on each marginal of a
tensor product.
}
