% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{count}
\alias{count}
\alias{count,CppSet-method}
\alias{count,CppUnorderedSet-method}
\alias{count,CppMultiset-method}
\alias{count,CppUnorderedMultiset-method}
\alias{count,CppMap-method}
\alias{count,CppUnorderedMap-method}
\alias{count,CppMultimap-method}
\alias{count,CppUnorderedMultimap-method}
\title{Count element frequency}
\usage{
count(x, values)
}
\arguments{
\item{x}{A CppSet, CppUnorderedSet, CppMultiset, CppUnorderedMultiset, CppMap, CppUnorderedMap, CppMultimap, or CppUnorderedMultimap object.}

\item{values}{A vector of elements to check. Refers to keys in the case of CppMap, CppUnorderedMap, CppMultimap, and CppUnorderedMultimap objects.}
}
\value{
Returns a vector of the same length as \code{values}, denoting for each value how often it occurs.
}
\description{
Count how often elements occur in a container.
}
\examples{
s <- cpp_set(4:9)
s
# 4 5 6 7 8 9

count(s, 9:11)
# [1] 1 0 0

m <- cpp_map(c("hello", "there"), c(1.2, 1.3))
m
# ["hello",1.2] ["there",1.3]

count(m, c("hello", "world"))
# [1] 1 0

}
\seealso{
\link{[}, \link{==}, \link{at}, \link{contains}, \link{size}, \link{empty}.
}
