% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify.R
\name{cpp_simplify}
\alias{cpp_simplify}
\title{Reduce the number of edges by removing non-intersection nodes, duplicated edges and isolated loops in the graph.}
\usage{
cpp_simplify(
  Graph,
  keep = NULL,
  rm_loop = TRUE,
  iterate = FALSE,
  silent = TRUE
)
}
\arguments{
\item{Graph}{An object generated by \link{makegraph} function.}

\item{keep}{Character or integer vector. Nodes of interest that will not be removed. Default to \code{NULL}}

\item{rm_loop}{Logical. if \code{TRUE}, isolated loops as removed. Default to \code{TRUE}}

\item{iterate}{Logical. If \code{TRUE}, process is repeated until only intersection nodes remain in the graph. Default to FALSE}

\item{silent}{Logical. If \code{TRUE} and iterate set to \code{TRUE}, number of iteration and number of removed nodes are printed to the console.}
}
\value{
The simplified cppRouting graph
}
\description{
Reduce the number of edges by removing non-intersection nodes, duplicated edges and isolated loops in the graph.
}
\details{
To understand why process can be iterated, see the package description : \url{https://github.com/vlarmet/cppRouting/blob/master/README.md}
}
\note{
Additional edge attributes like \code{aux}, \code{alpha}, \code{beta} and \code{capacity} will be removed.
The first iteration usually eliminates the majority of non-intersection nodes and is therefore faster.
}
\examples{
#Simple directed graph
edges<-data.frame(from=c(1,2,3,4,5,6,7,8),
                  to=c(0,1,2,3,6,7,8,5),
                  dist=c(1,1,1,1,1,1,1,1))

#Plot
if(requireNamespace("igraph",quietly = TRUE)){
igr<-igraph::graph_from_data_frame(edges)
plot(igr)
}

#Construct cppRouting graph
graph<-makegraph(edges,directed=TRUE)

#Simplify the graph, removing loop
simp<-cpp_simplify(graph, rm_loop=TRUE)

#Convert cppRouting graph to data frame
simp<-to_df(simp)

#Plot
if(requireNamespace("igraph",quietly = TRUE)){
igr<-igraph::graph_from_data_frame(simp)
plot(igr)
}

#Simplify the graph, keeping node 2 and keeping loop
simp<-cpp_simplify(graph,keep=2 ,rm_loop=FALSE)

#Convert cppRouting graph to data frame
simp<-to_df(simp)

#Plot
if(requireNamespace("igraph",quietly = TRUE)){
igr<-igraph::graph_from_data_frame(simp)
plot(igr)
}

}
