\name{unscaleProbCPLEX}
\alias{unscaleProbCPLEX}
\alias{CPXunscaleprob}

\title{
  Remove Any Scaling Applied to the Resident Problem
}

\description{
  Low level interface function to the IBM ILOG CPLEX function
  \code{CPXunscaleprob}.  Consult the IBM ILOG CPLEX documentation for more
  detailed information.
}

\usage{
  unscaleProbCPLEX(env, lp)
}

\arguments{
  \item{env}{
    An object of class \code{"\linkS4class{cplexPtr}"} as returned by
    \code{\link{openEnvCPLEX}}. This is basically a pointer to an
    IBM ILOG CPLEX environment.
  }
  \item{lp}{
    An object of class \code{"\linkS4class{cplexPtr}"} as returned by
    \code{\link{initProbCPLEX}}. This is basically a pointer to an
    IBM ILOG CPLEX problem object.
  }
}

\details{
  Interface to the C function \code{unscaleProb} which calls the CPLEX
  function \code{CPXunscaleprob}.
}

\value{
  Zero if successful, otherwise nonzero.
}

\references{
  The IBM ILOG CPLEX home page at
  \url{https://www.ibm.com/support/knowledgecenter/SSSA5P}.
}

\author{
  Gabriel Gelius-Dietrich <geliudie@uni-duesseldorf.de>

  Maintainer: Mayo Roettger <mayo.roettger@hhu.de>
}


\keyword{ optimize }

