% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/with.R
\name{with_something}
\alias{in_dir}
\alias{with_collate}
\alias{with_envvar}
\alias{with_lib}
\alias{with_libpaths}
\alias{with_locale}
\alias{with_makevars}
\alias{with_options}
\alias{with_par}
\alias{with_path}
\alias{with_something}
\title{Execute code in temporarily altered environment.}
\usage{
with_envvar(new, code, action = "replace")

with_locale(new, code)

with_collate(new, code)

in_dir(new, code)

with_libpaths(new, code)

with_lib(new, code)

with_options(new, code)

with_par(new, code)

with_path(new, code, add = TRUE)

with_makevars(new, code, path = file.path("~", ".R", "Makevars"))
}
\arguments{
\item{new}{values for setting}

\item{code}{code to execute in that environment}

\item{action}{(for \code{with_envvar} only): should new values
\code{"replace"}, \code{"suffix"}, \code{"prefix"} existing environmental
variables with the same name.}

\item{add}{Combine with existing values? Currently for
\code{\link{with_path}} only. If \code{FALSE} all existing
paths are overwritten, which don't you usually want.}

\item{path}{location of existing makevars to modify.}
}
\description{
\itemize{
  \item \code{in_dir}: working directory
  \item \code{with_collate}: collation order
  \item \code{with_envvar}: environmental variables
  \item \code{with_libpaths}: library paths, replacing current libpaths
  \item \code{with_lib}: library paths, prepending to current libpaths
  \item \code{with_locale}: any locale setting
  \item \code{with_options}: options
  \item \code{with_path}: PATH environment variable
  \item \code{with_par}: graphics parameters
}
}
\details{
if \code{NA} is used as a value with \code{with_envvar} those
environment variables will be unset.  If there are any duplicated variable
names only the last one is used.

If no existing makevars file exists or the fields in \code{new} do
not exist in the existing \code{Makevars} file then the fields are added to
the new file.  Existing fields which are not included in \code{new} are
appended unchanged.  Fields which exist in \code{Makevars} and in \code{new}
are modified to use the value in \code{new}.
}

