% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_regional_data.R
\name{get_regional_data}
\alias{get_regional_data}
\title{The main calculation function for covidregionaldata. The majority of the work is done in this function.}
\usage{
get_regional_data(country, totals = FALSE, include_level_2_regions = FALSE)
}
\arguments{
\item{country}{Character A string specifying the country to get data from. Not case dependent.
Name should be the English name. For a list of options see the README.}

\item{totals}{Boolean. If TRUE, returns totalled data per region up to today's date. If FALSE, returns the full dataset stratified by date and region.}

\item{include_level_2_regions}{Boolean. If TRUE, returns data stratified by level 2 regions. If FALSE, stratified by Level 1.
Note that Level 2 region data Sis not always available. In these cases the user will get a warning and the Level 1 data will be returned.}
}
\value{
A tibble with data related to cases, deaths, hospitalisations, recoveries and testing stratified by regions within the given country.
}
\description{
Gets raw data using the country-specific function. Adds the region codes.
Then adds columns which were missing from the raw data (calculating cumulative counts from new dailies and vice versa),
cleans and sanitises further. Adds rows and columns of NA values so that data is in a standard format.
}
\examples{

\dontrun{
 get_regional_data(country = "canada", totals = TRUE, include_level_2_regions = FALSE)
}

}
