% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ext_id}
\alias{ext_id}
\alias{External_Identifiers_Drug}
\alias{External_Identifiers_Polypeptide_Carrier_Drug}
\alias{External_Identifiers_Polypeptide_Enzyme_Drug}
\alias{External_Identifiers_Polypeptide_Target_Drug}
\alias{External_Identifiers_Transporter_Drug}
\title{External Identifiers for Drugs/ Carriers/ Enzymes/ Targets/ Transporters}
\format{
a tibble with following features:
\describe{
  \item{resource}{Name of the source database}
  \item{identifier}{Identifier for this drug in the given resource}
  \item{parent_key}{drugbank key}
}

An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 186 rows and 3 columns.

An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 12 rows and 3 columns.

An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 156 rows and 3 columns.

An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 203 rows and 3 columns.

An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 102 rows and 3 columns.
}
\source{
\href{https://docs.drugbankplus.com/xml/}{Drugbank Documentation}
}
\usage{
External_Identifiers_Drug

External_Identifiers_Polypeptide_Carrier_Drug

External_Identifiers_Polypeptide_Enzyme_Drug

External_Identifiers_Polypeptide_Target_Drug

External_Identifiers_Transporter_Drug
}
\description{
Identifiers used in other websites or databases providing information about
this drug.
}
\details{
Each drug may have one or more external identifier.

Drug identifiers may be provided for the following resources
\itemize{
  \item \href{https://www.wikipedia.org/}{Wikipedia}
  \item \href{http://www.ebi.ac.uk/chebi/}{ChEBI}
  \item \href{https://www.ebi.ac.uk/chembl/}{ChEMBL}
  \item \href{https://pubchem.ncbi.nlm.nih.gov/}{PubChem Compound}
  \item \href{https://pubchem.ncbi.nlm.nih.gov/}{PubChem Substance}
  \item \href{https://health-products.canada.ca/dpd-bdpp/index-eng.jsp}{Drugs
   Product Database (DPD)}
  \item \href{https://www.genome.jp/kegg/compound/}{KEGG Compound}
  \item \href{https://www.genome.jp/kegg/drug/}{KEGG Compound}
  \item \href{https://www.genome.jp/kegg/drug/}{KEGG Drug}
  \item \href{https://www.chemspider.com/}{ChemSpider}
  \item \href{https://bindingdb.org/}{BindingDB}
  \item \href{https://dailymed.nlm.nih.gov/}{National Drug Code Directory}
  \item \href{https://www.ncbi.nlm.nih.gov/genbank/}{GenBank}
  \item \href{https://www.pharmgkb.org/}{PharmGKB}
  \item \href{https://www.rcsb.org/}{PDB}
  \item \href{https://www.guidetopharmacology.org/}{Guide to Pharmacology}
  \item \href{https://zinc15.docking.org/}{ZINC}
  \item \href{https://www.nlm.nih.gov/research/umls/rxnorm/index.html}{RxCUI}
}
}
\keyword{datasets}
