% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covdepGE_package.R
\docType{package}
\name{covdepGE-package}
\alias{covdepGE-package}
\alias{_PACKAGE}
\title{covdepGE: Covariate Dependent Graph Estimation}
\description{
A covariate-dependent approach to Gaussian graphical modeling as described in Dasgupta et al. (2022). Employs a novel weighted pseudo-likelihood approach to model the conditional dependence structure of data as a continuous function of an extraneous covariate. The main function, covdepGE::covdepGE(), estimates a graphical representation of the conditional dependence structure via a block mean-field variational approximation, while several auxiliary functions (inclusionCurve(), matViz(), and plot.covdepGE()) are included for visualizing the resulting estimates.
}
\details{
The conditional dependence structure (CDS) of a data matrix with
\eqn{p} variables can be modeled as an undirected graph with \eqn{p}
vertices, where two variables are connected if, and only if, the two
variables are dependent given the remaining variables in the data. Gaussian
graphical modeling (GGM) seeks to capture the CDS of the data under the
assumption that the data are normally distributed. This distributional
assumption is convenient for inference, as the CDS is given by the sparsity
structure of the precision matrix, where the precision matrix is defined as
the inverse covariance matrix of the data.

There is extensive GGM literature and many R packages for GGM, however, all
make the restrictive assumption that the precision matrix is homogeneous
throughout the data, or that there exists a partition of homogeneous
subgroups. \code{covdepGE} avoids this strong assumption by utilizing information
sharing to model the CDS as varying continuously with an extraneous
covariate. Intuitively, this implies that observations having similar
extraneous covariate values will have similar precision matrices.

To facilitate information sharing while managing complexity, \code{covdepGE} uses
an efficient variational approximation conducted under the novel weighted
pseudo-likelihood framework proposed by (1). \code{covdepGE} further accelerates
inference by employing parallelism and executing expensive iterative
computations in  C++. Additionally, \code{covdepGE} offers a principled,
data-driven approach for hyperparameter specification that only requires the
user to input data and extraneous covariates to perform inference. Finally,
\code{covdepGE} offers several wrappers around \code{ggplot2} for seamless
visualization of resulting estimates, such as \code{matViz}, \code{inclusionCurve}, and
the S3 method \code{plot.covdepGE}.
}
\references{
(1) Sutanoy Dasgupta, Peng Zhao, Prasenjit Ghosh, Debdeep Pati, and Bani
Mallick. An approximate Bayesian approach to covariate-dependent graphical
modeling. pages 1–59, 2022.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/JacobHelwig/covdepGE}
  \item Report bugs at \url{https://github.com/JacobHelwig/covdepGE/issues}
}

}
\author{
\strong{Maintainer}: Jacob Helwig \email{jacob.a.helwig@tamu.edu}

Authors:
\itemize{
  \item Sutanoy Dasgupta \email{sutanoy@stat.tamu.edu}
  \item Peng Zhao \email{pzhao@stat.tamu.edu}
  \item Bani Mallick \email{bmallick@stat.tamu.edu}
  \item Debdeep Pati \email{debdeep@stat.tamu.edu}
}

}
