% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covaprop.R
\docType{class}
\name{covaprop-class}
\alias{covaprop-class}
\alias{covaprop}
\alias{show,covaprop-method}
\title{Class "covaprop"}
\usage{
covaprop(cblock, cstat, nonseptype = NULL, sign.level = 0.05)

\S4method{show}{covaprop}(object)
}
\arguments{
\item{cblock}{object of class \code{covablocks}}

\item{cstat}{object of class \code{covastat} or \code{covastatM}}

\item{nonseptype}{integer; this argumet is required only for objects
(\code{cblock} and \code{cstat}) defined to perform the type of non
separability test, otherwise it has to be set equal to \code{NULL} (default choice).
Set \code{nonseptype=0} for testing the null hypothesis that the non
separability is non positive; set \code{nonseptype=1} for testing the null
hypothesis that the non separability is non negative}

\item{sign.level}{level of significance}

\item{object}{object of class \code{covaprop} for method \code{show}}
}
\description{
A function for testing some properties (symmetry, separability, type of
non-separability) of spatio-temporal covariance functions and some classes
of space-time covariance models
}
\section{Slots}{

\describe{
\item{\code{test.statistics}}{numeric; the value of the test statistic}

\item{\code{p.value}}{numeric; the lower tail p value of the test statistic}

\item{\code{df}}{numeric; the degrees of freedom, if available}

\item{\code{typetest}}{character; contains the code of the test to be performed}
}}

\note{
{
A message helps to decide for either reject the null hypothesis in favor of
the alternative or not reject it, at a specific level of significance
\itemize{
\item The test on full symmetry (the argument of the slot \code{@typetest} is
equal to \code{"sym"}) represents the first step
for the selection of a suitable class of spatio-temporal covariance functions.
According to the definition of full symmetry, the null hypothesis to be
tested is \eqn{H_0: C(h,u) - C(h,-u)=0}

\item The test of separability (the argument of the slot \code{@typetest} is
equal to \code{"sep"}) represents the second
step of the testing procedure. According to the definition of separability,
the null hypothesis to be tested is
\eqn{H_0: C(h, u)/C(h, 0) - C(0, u)/C(0,0)=0}

\item The test on the type of non separability (the argument of the slot
\code{@typetest} is equal to \code{"tnSep"})
represents the third step for the selection of a suitable class of space-time
covariance functions.
According to the definition of type of non separability, the null hypothesis
to be tested is that the non separability is non negative
\eqn{H_0: C(h,u)/C(h,0) - C(0,u)/C(0,0) > 0}
or
\eqn{H_0: C(h,u)/C(h,0) - C(0,u)/C(0,0) < 0}
if the null hypothesis to test is that the non separability is non positive

\item If the argument of the slot \code{@typetest} is equal to \code{"productSum"}
\code{"intProduct"} or \code{"gneiting"}, the goodness of a specific class of
space-time covariance function will be tested. For this testing procedure
the generic null hypothesis is: \eqn{H_0: Af(G)=0}
}
For the analytic expression of each test statistic and its probability
distribution see Cappello et al. (2018). In the same contribution the
different \code{f(G)} are given for each test to be computed.

A stop occurs if the type of test set in \code{cblock} is not consistent with
the type of test set in \code{cstat}.
}
}
\examples{
# --start define the STFDF rr_13-- #
library(sp)
library(spacetime)
library(gstat)
data(air)
ls()
if (!exists("rural")) rural = STFDF(stations, dates, data.frame(PM10 =
as.vector(air)))
rr = rural[,"2005::2010"]
unsel = which(apply(as(rr, "xts"), 2, function(x) all(is.na(x))))
r5to10 = rr[-unsel,]
rr_13 <- r5to10[c("DEHE046","DESN049","DETH026","DENW063","DETH061","DEBY047",
"DENW065","DEUB029","DENW068","DENI019","DEHE051","DERP016","DENI051"),
"2005::2006"]
# --end define the STFDF rr_13-- #

sel.staz.sym <- c("DERP016", "DENW065", "DEHE051", "DETH026", "DENW063", "DENI019",
"DENW068", "DEHE046", "DEUB029", "DEBY047", "DETH061", "DESN049")

sp.couples.in.sym <- matrix(data = c("DERP016", "DENW065", "DEHE051", "DETH026",
"DENW063", "DENI019", "DENW068", "DEHE046", "DEUB029", "DEBY047", "DETH061", "DESN049"),
ncol = 2, byrow = TRUE)

t.couples.in.sym <- c(1, 2)

couples.sym <- couples(sel.staz = sel.staz.sym, sp.couples.in = sp.couples.in.sym,
t.couples.in = t.couples.in.sym, typetest = "sym", typecode = character())

block.sym <- blocks(lb = 40, ls = 10, matdata = rr_13, pardata1 = 1, pardata2 = 1,
stpairs = couples.sym)

covabl.sym <- covablocks(stblocks = block.sym, stpairs = couples.sym, typetest = "sym")

covast.sym <- covastat(matdata = rr_13, pardata1 = 1, pardata2 = 1,
stpairs = couples.sym, typetest = "sym")

test.sym <- covaprop(cblock = covabl.sym, cstat = covast.sym, nonseptype = NULL,
sign.level = 0.05)

### method for covaprop
#1. show
test.sym

}
\references{
Li, B., Genton, M.G., Sherman, M., 2007, A nonparametric assessment
of properties of spacetime covariance functions.
Journal of the American Statistical Association, \bold{102} 736--744.

De Iaco, S., Palma, M., Posa, D., 2016. A general procedure for selecting a
class of fully symmetric space-time covariance functions.
Environmentrics, \bold{27(4)} 212--224.

Cappello, C., De Iaco, S., Posa, D., 2018, Testing the type of
non-separability and some classes of covariance models for space-time data.
Stochastic Environmental Research and Risk Assessment,
\bold{32} 17--35
}
\seealso{
\linkS4class{couples}

\linkS4class{blocks}

\linkS4class{covablocks}

\linkS4class{covastat}
}
