% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hourly_helpers.R
\name{hourly_stationmap}
\alias{hourly_stationmap}
\title{Plot hourly weather stations for a particular county.}
\usage{
hourly_stationmap(fips, hourly_data, point_color = "firebrick",
  point_size = 2, station_label = FALSE)
}
\arguments{
\item{fips}{A five-digit FIPS county code.}

\item{hourly_data}{A list returned from the function \code{hourly_df}.}

\item{point_color}{Character string with color for points
mapping the locations of weather stations (passes to \code{ggplot}).}

\item{point_size}{Character string with size for for points
mapping the locations of weather stations (passes to \code{ggplot}).}

\item{station_label}{TRUE / FALSE Whether to include labels for
each weather station.}
}
\value{
A \code{ggplot} object mapping all weather stations for a particular
   county that satisfy the conditions present in \code{hourly_df}'s
   arguments (year(s), coverage, and/or weather variables). Because hourly
   data is pulled by radius from each county's geograph center, this plot
   includes the calculated radius from which stations are pulled for that
   county. This radius
   is calculated for each county using 2010 U.S. Census Land Area data.
   2011 U.S. Census cartographic boundary shapefiles are used to proved
   county outlines, included on this plot as well. Note: Because stations
   are pulled within a radius from the county's geographic center, depending
   on the shape of the county, weather stations from outside the county's
   boundaries may sometimes be providing data for that county and some
   weather stations within the county may not be included.
}
\description{
Produces a \code{ggplot} object mapping stations that contribute
to the weather data returned by \code{hourly_data}.
}
\examples{
\dontrun{
hourly_data <- hourly_df(fips = "12086", year = 1992,
                         var = c("wind_speed", "temperature"))
hourly_stationmap("12086", hourly_data)
}

}

