% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_viz.cosimmr_output.R
\name{prior_viz}
\alias{prior_viz}
\title{Plot the prior distribution for a cosimmr run}
\usage{
prior_viz(
  cosimmr_out,
  plot = TRUE,
  include_posterior = TRUE,
  n_sims = 10000,
  scales = "free"
)
}
\arguments{
\item{cosimmr_out}{A run of the cosimmr model from \code{\link{cosimmr_ffvb}}}

\item{plot}{Whether to create a density plot of the prior or not. The simulated prior values are returned as part of the object}

\item{include_posterior}{Whether to include the posterior distribution on top of the priors. Defaults to TRUE. The posterior returned is of the mean value of covariates}

\item{n_sims}{The number of simulations from the prior distribution}

\item{scales}{The type of scale from \code{facet_wrap} allowing for \code{fixed}, \code{free}, \code{free_x}, \code{free_y}}
}
\value{
A list containing \code{plot}: the ggplot object (useful if requires customisation), and \code{sim}: the simulated prior values which can be compared with the posterior densities

#' @author Emma Govan <emmagovan@gmail.com> Andrew Parnell
}
\description{
This function takes the output from \code{\link{cosimmr_ffvb}} and plots the 
prior distribution to enable visual
inspection. This can be used by itself or together with
\code{\link{posterior_predictive}} to visually evaluate the influence of
the prior on the posterior distribution.
}
\examples{
\donttest{
data(geese_data_day1)
cosimmr_1 <- with(
  geese_data_day1,
  cosimmr_load(
    formula = mixtures ~ 1,
    source_names = source_names,
    source_means = source_means,
    source_sds = source_sds,
    correction_means = correction_means,
    correction_sds = correction_sds,
    concentration_means = concentration_means
  )
)

# Plot
plot(cosimmr_1)

# Print
cosimmr_1

# FFVB run
cosimmr_1_out <- cosimmr_ffvb(cosimmr_1)

# Prior predictive
prior <- prior_viz(cosimmr_1_out)
head(prior$p_prior_sim)
summary(prior$p_prior_sim)
}
}
\seealso{
\code{\link{cosimmr_ffvb}} for creating objects suitable for this
function
}
