% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cosimmr_input.R
\name{plot.cosimmr_input}
\alias{plot.cosimmr_input}
\title{Plot the \code{cosimmr_input} data created from \code{cosimmr_load}}
\usage{
\method{plot}{cosimmr_input}(
  x,
  tracers = c(1, 2),
  title = "Tracers plot",
  xlab = colnames(x$mixtures)[tracers[1]],
  ylab = colnames(x$mixtures)[tracers[2]],
  sigmas = 1,
  mix_name = "Mixtures",
  colour = TRUE,
  colour_by_cov = FALSE,
  cov_name = NULL,
  ggargs = NULL,
  ...
)
}
\arguments{
\item{x}{An object created via the function \code{\link{cosimmr_load}}}

\item{tracers}{The choice of tracers to plot. If there are more than two
tracers, it is recommended to plot every pair of tracers to determine
whether the mixtures lie in the mixing polygon defined by the sources}

\item{title}{A title for the graph}

\item{xlab}{The x-axis label. By default this is assumed to be delta-13C but
can be made richer if required. See examples below.}

\item{ylab}{The y-axis label. By default this is assumed to be delta-15N in
per mil but can be changed as with the x-axis label}

\item{sigmas}{The number of standard deviations to plot on the source
values. Defaults to 1.}

\item{mix_name}{A optional string containing the name of the mixture
objects, e.g. Geese.}

\item{colour}{If TRUE (default) creates a plot. If not, puts the plot in
black and white}

\item{colour_by_cov}{if TRUE this allows users to colour the mixtures on the 
isospace plot by a specified covariate. Defaults to FALSE}

\item{cov_name}{The name of the covariate the user wishes to colour the 
mixture points on the plot by}

\item{ggargs}{Extra arguments to be included in the ggplot (e.g. axis limits)}

\item{...}{Not used}
}
\value{
isospace plot
}
\description{
This function creates iso-space (AKA tracer-space or delta-space) plots.
They are vital in determining whether the data are suitable for running in a
SIMM.
}
\details{
It is desirable to have the vast majority of the mixture observations to be
inside the convex hull defined by the food sources. When there are more than
two tracers (as in one of the examples below) it is recommended to plot all
the different pairs of the food sources. See the vignette for further
details of richer plots.
}
\examples{
\donttest{
# A simple example with 10 observations, 4 food sources and 2 tracers
data(geese_data_day1)
cosimmr_1 <- with(
  geese_data_day1,
  cosimmr_load(
    formula = mixtures ~ c(1,2,3,2,3,1,2,3,1),
    source_names = source_names,
    source_means = source_means,
    source_sds = source_sds,
    correction_means = correction_means,
    correction_sds = correction_sds,
    concentration_means = concentration_means
  )
)

# Plot
plot(cosimmr_1)

### A more complicated example with 30 obs, 3 tracers and 4 sources
data(simmr_data_2)
cosimmr_3 <- with(
  simmr_data_2,
  cosimmr_load(
    formula = mixtures ~ 1,
    source_names = source_names,
    source_means = source_means,
    source_sds = source_sds,
    correction_means = correction_means,
    correction_sds = correction_sds,
    concentration_means = concentration_means
  )
)

# Plot 3 times - first default d13C vs d15N
plot(cosimmr_3)
# Now plot d15N vs d34S
plot(cosimmr_3, tracers = c(2, 3))
# and finally d13C vs d34S
plot(cosimmr_3, tracers = c(1, 3))
}
}
\seealso{
See \code{\link{plot.cosimmr_output}} for plotting the output of a
simmr run. See \code{\link{cosimmr_ffvb}} for running a cosimmr object once the
iso-space is deemed acceptable.
}
\author{
Emma Govan <emmagovan@gmail.com>, Andrew Parnell
}
