% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_correlation_funnel.R
\name{plot_correlation_funnel}
\alias{plot_correlation_funnel}
\title{Plot a Correlation Funnel}
\usage{
plot_correlation_funnel(data, interactive = FALSE, limits = c(-1, 1),
  alpha = 1)
}
\arguments{
\item{data}{A \code{tibble} or \code{data.frame}}

\item{interactive}{Returns either a static (\code{ggplot2}) visualization or an interactive (\code{plotly}) visualization}

\item{limits}{Sets the X-Axis limits for the correlation space}

\item{alpha}{Sets the transparency of the points on the plot.}
}
\value{
A static \code{ggplot2} plot or an interactive \code{plotly} plot
}
\description{
\code{plot_correlation_funnel} returns a correlation funnel visualization in either static (\code{ggplot2}) or
interactive (\code{plotly}) formats.
}
\examples{
library(dplyr)
library(correlationfunnel)

marketing_campaign_tbl \%>\%
    select(-ID) \%>\%
    binarize() \%>\%
    correlate(TERM_DEPOSIT__yes) \%>\%
    plot_correlation_funnel()


}
\seealso{
\code{\link[=binarize]{binarize()}}, \code{\link[=correlate]{correlate()}}
}
