% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_functions.R
\name{est_mu_bhat}
\alias{est_mu_bhat}
\title{Estimate the true effect at the causal variant using estimated
effect sizes and their standard errors}
\usage{
est_mu_bhat(bhat, V, N0, N1, p1 = 1e-04, W = 0.2)
}
\arguments{
\item{bhat}{Vector of estimated effect sizes}

\item{V}{Prior variance for estimated effect sizes}

\item{N0}{Number of controls}

\item{N1}{Number of cases}

\item{p1}{Prior probability a SNP is associated with the trait, default 1e-4}

\item{W}{Prior for the standard deviation of the effect size parameter, beta}
}
\value{
Estimate of the true effect at the causal variant
}
\description{
Estimate the true effect at the causal variant using estimated
effect sizes and their standard errors
}
\examples{

nsnps <- 100
N0 <- 5000 # number of controls
N1 <- 5000 # number of cases

maf <- runif(nsnps, 0.05, 0.3)

varbeta <- Var.data.cc(f = maf, N = N0 + N1, s = N1/(N0+N1))

bhats = rnorm(nsnps,0,0.2) # log(OR)

est_mu_bhat(bhat = bhats, V = varbeta, N0 = N0, N1 = N1)

}
\author{
Anna Hutchinson
}
