% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_information.r
\name{feature_stats}
\alias{feature_stats}
\title{Feature statistics}
\usage{
feature_stats(tc, feature, context_level = c("document", "sentence"))
}
\arguments{
\item{tc}{a tCorpus}

\item{feature}{The name of the feature column}

\item{context_level}{Should results be returned at document or sentence level}
}
\value{
a data.frame
}
\description{
Compute a number of useful statistics for features: term frequency, idf, etc.
}
\examples{
tc = create_tcorpus(c('Text one first sentence. Text one second sentence', 'Text two'),
                    split_sentences = TRUE)

\donttest{
fs = feature_stats(tc, 'token')
head(fs)
fs = feature_stats(tc, 'token', context_level = 'sentence')
head(fs)
}
}
