% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterator-collect.R
\name{async_collect}
\alias{async_collect}
\title{Collect elements of an asynchronous iterator}
\usage{
async_collect(x, n = NULL)
}
\arguments{
\item{x}{An iterator function.}

\item{n}{The number of elements to collect. If \code{x} is an infinite
sequence, \code{n} must be supplied to prevent an infinite loop.}
}
\description{
\code{async_collect()} takes an asynchronous iterator, i.e. an iterable
function that is also awaitable. \code{async_collect()} returns an
awaitable that eventually resolves to a list containing the values
returned by the iterator. The values are collected until exhaustion
unless \code{n} is supplied. The collection is grown geometrically for
performance.
}
\examples{

# Emulate an async stream by yielding promises that resolve to the
# elements of the input vector
generate_stream <- async_generator(function(x) for (elt in x) yield(elt))

# You can await `async_collect()` in an async function. Once the
# list of values is resolved, the async function resumes.
async(function() {
  stream <- generate_stream(1:3)
  values <- await(async_collect(stream))
  values
})
}
