/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.data.feature.array;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uno.informatics.data.SimpleEntity;
import uno.informatics.data.dataset.FeatureDataRow;
import uno.informatics.data.pojo.PropertyHandler;
import uno.informatics.data.pojo.SimpleEntityPojo;

public class ArrayFeatureDataRow
extends PropertyHandler
implements FeatureDataRow {
    public static final String HEADER_PROPERTY = FeatureDataRow.class.getName() + ".header";
    private SimpleEntity header;
    private Object[] values;

    public ArrayFeatureDataRow(Object[] values) {
        this.values = values != null ? values : new Object[0];
    }

    public ArrayFeatureDataRow(SimpleEntity header, Object[] values) {
        this.setHeader(header);
        this.values = values != null ? values : new Object[0];
    }

    private ArrayFeatureDataRow(boolean hasHeader, Object[] values) {
        if (values != null && values.length > 0) {
            if (hasHeader) {
                this.values = new Object[values.length - 1];
                this.setHeaderAsObject(values[0]);
                for (int i = 0; i < values.length - 1; ++i) {
                    this.values[i] = values[i + 1];
                }
            } else {
                this.values = new Object[values.length];
                for (int i = 0; i < values.length; ++i) {
                    this.values[i] = values[i];
                }
            }
        } else {
            this.values = new Object[0];
        }
    }

    public ArrayFeatureDataRow(List<Object> values) {
        this(null, values);
    }

    public ArrayFeatureDataRow(SimpleEntity header, List<Object> values) {
        this.setHeaderAsObject(header);
        this.values = values != null ? values.toArray() : new Object[0];
    }

    private ArrayFeatureDataRow(boolean hasHeader, List<Object> values) {
        if (values != null && !values.isEmpty()) {
            if (hasHeader) {
                Iterator<Object> iterator = values.iterator();
                this.values = new Object[values.size() - 1];
                Object header = iterator.next();
                this.setHeaderAsObject(header);
                int i = 0;
                while (iterator.hasNext()) {
                    this.values[i] = iterator.next();
                    ++i;
                }
            } else {
                this.values = values.toArray();
            }
        } else {
            this.values = new Object[0];
        }
    }

    @Override
    public final SimpleEntity getHeader() {
        return this.header;
    }

    public final void setHeader(SimpleEntity header) {
        SimpleEntity oldValue = this.header;
        this.header = header;
        this.getPropertyChangeSupport().firePropertyChange(HEADER_PROPERTY, oldValue, this.header);
    }

    private final void setHeaderAsObject(Object header) {
        if (header != null) {
            if (header instanceof String) {
                this.setHeader(new SimpleEntityPojo((String)header, (String)header));
            } else if (header instanceof SimpleEntity) {
                this.setHeader((SimpleEntity)header);
            } else {
                this.setHeader(new SimpleEntityPojo(header.toString(), header.toString()));
            }
        }
    }

    @Override
    public final List<Object> getValues() {
        return this.toList(this.values);
    }

    @Override
    public final Object[] getValuesAsArray() {
        return this.values;
    }

    @Override
    public final Object getValue(int columnIndex) {
        return this.values[columnIndex];
    }

    @Override
    public int getColumnCount() {
        return this.values.length;
    }

    private List<Object> toList(Object[] array) {
        ArrayList<Object> list = new ArrayList<Object>(array.length);
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static FeatureDataRow createRow(boolean header, List<Object> values) {
        if (header) {
            return new ArrayFeatureDataRow(header, values);
        }
        return new ArrayFeatureDataRow(values);
    }

    public static FeatureDataRow createRow(boolean header, Object[] values) {
        if (header) {
            return new ArrayFeatureDataRow(header, values);
        }
        return new ArrayFeatureDataRow(null, values);
    }

    public static FeatureDataRow createRow(SimpleEntity header, List<Object> values) {
        return new ArrayFeatureDataRow(header, values);
    }

    public static FeatureDataRow createRow(SimpleEntity header, Object[] values) {
        return new ArrayFeatureDataRow(header, values);
    }
}

