% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_measure.R
\name{base_measure}
\alias{base_measure}
\title{Base Measure for Mixture Models}
\usage{
base_measure(idx, dim, pars, hpars, eval)
}
\arguments{
\item{idx}{A unique index for the base measure.}

\item{dim}{A dimension for the support of the base measure.}

\item{pars}{A list of parameters used to generate mixture components.}

\item{hpars}{A list of hyperparameters used to generate \code{pars}.}

\item{eval}{An evaluation function taking \code{phi}, a list of mixture parameter
matrices, \code{grd}, a grid vector, \code{f}, a character string indicating whether
to calculate the gradient, density, or distribution function, and
\code{nthreads}, a number of threads to utilize for parallel execution.}
}
\value{
A \code{base_measure} object for use in the sequence resampling scheme for
mixtures.
}
\description{
A structure for wrapping base measures as in Escobar and West
(1995).
}
\references{
\itemize{
\item Escobar M. D., West, M. (1995) Bayesian Density Estimation and
Inference Using Mixtures. Journal of the American Statistical Association.
DOI: \doi{10.1080/01621459.1995.10476550}
}
}
\seealso{
{\code{\link[=seqre]{seqre()}}}
}
