% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/down_lo_EUS.R
\name{down_lo_EUS}
\alias{down_lo_EUS}
\title{Download  a dataset (tibble) from Eurostat.}
\usage{
down_lo_EUS(
  indicator_code,
  fromTime,
  toTime,
  gender = c(NA, "T", "F", "M")[1],
  ageInterv = NA,
  rawDump = FALSE,
  uniqueIdentif = 1
)
}
\arguments{
\item{indicator_code}{defined by Eurostat as id.}

\item{fromTime}{first year to be considered.}

\item{toTime}{last year to be considered.}

\item{gender}{if available, the gender of interest
c("T","F","M") for Total, Females, Males.}

\item{ageInterv}{if available,
a string of character representing the age class to
be considered as coded by Eurostat, for example 'Y15-74'.}

\item{rawDump}{if TRUE raw downloaded data are returned, otherwise
filtered values are provided.}

\item{uniqueIdentif}{identifiers of further conditional variables (1,2,...).}
}
\value{
a dataset (tibble) years by countries, possibly conditioned
         to gender, within the  list  as  component named res.
         If rawDump is TRUE then bulk data are provided. The list component
         msg may contain auxiliary information on conditioning variables.
}
\description{
From the Eurostat web site, a dataset is created whose structure is
time by countries, possibly conditioned to  gender, age class and other
variables. All indicators are supported and, after  downloading, data are not
filtered by country members (geo) and/or EU clusters.
}
\details{
It is up to the user to proceed with further filtering/selection
so that the desired
collection of member states is obtained.
}
\examples{
\donttest{
myDF1 <- down_lo_EUS(indicator_code = "lfsa_ergaed",
                    fromTime = 2005,
                    toTime = 2015,
                    gender=  "F",
                    ageInterv = NA,
                    rawDump=FALSE,
                    uniqueIdentif = 1)

myDF2 <- down_lo_EUS(indicator_code = "lfsa_ergaed",
                    fromTime = 2005,
                    toTime = 2015,
                    gender=  "M",
                    ageInterv = "Y15-64",
                    rawDump=FALSE,
                    uniqueIdentif = 3)

}
}
\references{
{\url{https://unimi2013-my.sharepoint.com/:u:/g/personal/federico_stefanini_unimi_it/EW0cVSIgbtZAvLPNbqcxdX8Bfn5VGSRHfAH88hQwc_RIEQ?e=MgtSZu}}
}
