% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/the_2xc_table.R
\name{the_2xc_table}
\alias{the_2xc_table}
\title{The 2xc table}
\usage{
the_2xc_table(n, alpha = 0.05, direction = "increasing")
}
\arguments{
\item{n}{the total number of observations}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}

\item{direction}{the direction of the success probabilities}
}
\value{
NULL. This function should be called for its printed output.
}
\description{
The 2xc table
}
\examples{
\dontrun{
# The Adolescent Placement Study (Fontanella et al., 2008)
the_2xc_table(fontanella_2008)

# Postoperative nausea (Lydersen et al., 2012a)
the_2xc_table(lydersen_2012a, direction = "decreasing")
}
}
