% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Peto_OR_estimate_stratified_2x2.R
\name{Peto_OR_estimate_stratified_2x2}
\alias{Peto_OR_estimate_stratified_2x2}
\title{The Peto estimate of the common odds ratio across strata}
\usage{
Peto_OR_estimate_stratified_2x2(n)
}
\arguments{
\item{n}{the observed table (a 2x2xk matrix, where k is the number of strata)}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The Peto estimate of the common odds ratio across strata

Described in Chapter 10 "Stratified 2x2 Tables and Meta-Analysis"
}
\examples{
# Smoking and lung cancer (Doll and Hill, 1950)
Peto_OR_estimate_stratified_2x2(doll_hill_1950)

# Prophylactice use of Lidocaine in myocardial infarction (Hine et al., 1989)
Peto_OR_estimate_stratified_2x2(hine_1989)

}
