% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cumulative_models_for_rxc.R
\name{Cumulative_models_for_rxc}
\alias{Cumulative_models_for_rxc}
\title{Cumulative logit and probit models}
\usage{
Cumulative_models_for_rxc(
  n,
  linkfunction = "logit",
  alpha = 0.05,
  printresults = TRUE
)
}
\arguments{
\item{n}{the observed table (an rxc matrix)}

\item{linkfunction}{either "logit" or "probit"}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A list containing the results of statistical tests for the
goodness-of-fit of a proportional odds model, the effect in a proportional
odds model and row comparisons
}
\description{
Cumulative logit and probit models

Described in Chapter 7 "The rxc Table"
}
\examples{
# Psychiatric diag. vs BMI with hyperkinetic disorders
# as reference category (Table 7.5)
n <- rbind(
  c(19, 130, 64), c(3, 55, 23), c(8, 102, 36), c(6, 14, 1), c(5, 21, 12), c(7, 26, 18)
)
Cumulative_models_for_rxc(n)

# LBW vs psych. morbidity with control as reference category (Table 7.6)
n <- rbind(c(51, 7, 6), c(22, 4, 12), c(24, 9, 10))
Cumulative_models_for_rxc(n)
}
