% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgrestiCaffo_CI_2x2.R
\name{AgrestiCaffo_CI_2x2}
\alias{AgrestiCaffo_CI_2x2}
\title{The Agresti-Caffo confidence interval for the difference between probabilities}
\usage{
AgrestiCaffo_CI_2x2(n, alpha = 0.05, printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (a 2x2 matrix)}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}

\item{printresults}{display results (F = no, T = yes)}
}
\value{
A data frame containing lower, upper and point estimates of the statistic
}
\description{
The Agresti-Caffo confidence interval for the difference between probabilities

Described in Chapter 4 "The 2x2 Table"
}
\examples{
# An RCT of high vs standard dose of epinephrine (Perondi et al., 2004):
AgrestiCaffo_CI_2x2(n = matrix(c(7,27,1,33), nrow=2, byrow=TRUE))
# The association between CHRNA4 genotype and XFS (Ritland et al., 2007):
AgrestiCaffo_CI_2x2(n = matrix(c(0,16,15,57), nrow=2, byrow=TRUE))
}
