% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wald_test_CC_1x2.R
\name{Wald_test_CC_1x2}
\alias{Wald_test_CC_1x2}
\title{The Wald test with continuity correction for the binomial probability (pi)}
\usage{
Wald_test_CC_1x2(X, n, pi0, printresults = TRUE)
}
\arguments{
\item{X}{the number of successes}

\item{n}{the total number of observations}

\item{pi0}{a given probability}

\item{printresults}{display results (0 = no, 1 = yes)}
}
\value{
A vector containing the two-sided p-value and the Wald test statistic
}
\description{
The Wald test with continuity correction for the binomial probability (pi)

H_0: pi = pi0  vs  H_A: pi ~= pi0 (two-sided)
}
\examples{
# The number of 1st order male births (adapted from Singh et al. 2010)
Wald_test_CC_1x2(X=250, n=533, pi0=0.1)
# The number of 2nd order male births (adapted from Singh et al. 2010)
Wald_test_CC_1x2(X=204, n=412, pi0=0.1)
# The number of 3rd order male births (adapted from Singh et al. 2010)
Wald_test_CC_1x2(X=103, n=167, pi0=0.1)
# The number of 4th order male births (adapted from Singh et al. 2010)
Wald_test_CC_1x2(X=33, n=45, pi0=0.1)
# Ligarden et al. (2010)
Wald_test_CC_1x2(X=13, n=16, pi0=0.1)
}
