% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/history.R
\name{History}
\alias{History}
\alias{print_data}
\alias{reindex}
\alias{delete_empty_rows}
\alias{clear_data_table}
\alias{set_data_table}
\alias{get_data_table}
\alias{set_data_frame}
\alias{get_data_frame}
\alias{load}
\alias{cumulative}
\alias{save}
\title{History}
\description{
The R6 class \code{History} keeps a log of all \code{Simulator} interactions
in its internal \code{data.table}. It also provides basic data summaries,
and can save or load simulation log data files.
}
\section{Usage}{

\preformatted{
History <- History$new(n = 1, save_context = FALSE, save_theta = FALSE)
}
}

\section{Arguments}{


\describe{
\item{\code{n}}{
\code{integer}. The number of rows, to be preallocated during initialization.
}
\item{\code{save_context}}{
\code{logical}. Save context matrix \code{X} when writing simulation data?
}
\item{\code{save_theta}}{
\code{logical}. Save parameter lists \code{theta} when writing simulation data?
}

}
}

\section{Methods}{


\describe{

\item{\code{reset()}}{
Resets a \code{History} instance to its original initialisation values.
}
\item{\code{insert(index,
                     t,
                     action,
                     reward,
                     agent_name,
                     simulation_index,
                     context_value = NA,
                     theta_value = NA)}}{
Saves one row of simulation data. Is generally not called directly, but from a {Simulator} instance.
}
\item{\code{save(filename = NA)}}{
Writes the \code{History} log file in its default data.table format,
with \code{filename} as the name of the file which the data is to be written to.
}
\item{\code{load = function(filename, interval = 0)}}{
Reads a \code{History} log file in its default \code{data.table} format,
with \code{filename} as the name of the file which the data are to be read from.
If \code{interval} is larger than 0, every \code{interval} of data is read instead of the
full data file. This can be of use with (a first) analysis of very large data files.
}
\item{\code{get_data_frame()}}{
Returns the \code{History} log as a \code{data.frame}.
}
\item{\code{get_data_table()}}{
Returns the \code{History} log as a \code{data.table}.
}
\item{\code{set_data_table(dt)}}{
Sets the \code{History} log with the data in \code{data.table} \code{dt}.
}
\item{\code{clear_data_table()}}{
Clears the \code{History} log.
}
\item{\code{save_csv(filename = NA, context_to_columns = FALSE)}}{
Saves History data to csv file. When context_to_columns is TRUE, the "context" column will
be split over multiple columns X1 to X...
}
\item{\code{delete_empty_rows()}}{
Deletes all empty rows in the \code{History} log and re-indexes the \code{t} column grouped
by agent and simulation.
}
\item{\code{reindex(truncate = TRUE)}}{
Removes empty rows from the \code{History} log, reindexes the \code{t} column, and,
if \code{truncate} is \code{TRUE}, truncates the resulting data to the shortest simulation
grouped by agent and simulation.
}
\item{\code{reindex(truncate = TRUE)}}{
Removes empty rows from the \code{History} log, reindexes the \code{t} column, and,
if \code{truncate} is \code{TRUE}, truncates the resulting data to the shortest simulation
grouped by agent and simulation.
}
\item{\code{print_data()}}{
Prints a summary of the \code{History} log.
}
\item{\code{data}}{
Active binding, read access to History's internal data.table.
}
\item{\code{cumulative}}{
Active binding, read access to cumulative data by name through $ accessor.
}
\item{\code{meta}}{
Active binding, read access to meta data by name through $ accessor.
}
}
}

\examples{
\dontrun{

  policy    <- EpsilonGreedyPolicy$new(epsilon = 0.1)
  bandit    <- BasicBernoulliBandit$new(weights = c(0.6, 0.1, 0.1))

  agent     <- Agent$new(policy, bandit, name = "E.G.", sparse = 0.5)

  history   <- Simulator$new(agents = agent,
                             horizon = 10,
                             simulations = 10)$run()

  summary(history)

  plot(history)

  dt <- history$get_data_table()

  df <- history$get_data_frame()

  print(history$cumulative$E.G.$cum_regret_sd)

  print(history$cumulative$E.G.$cum_regret)

}

}
\seealso{
Core contextual classes: \code{\link{Bandit}}, \code{\link{Policy}}, \code{\link{Simulator}},
\code{\link{Agent}}, \code{\link{History}}, \code{\link{Plot}}

Bandit subclass examples: \code{\link{BasicBernoulliBandit}}, \code{\link{ContextualLogitBandit}},  \code{\link{OfflineReplayEvaluatorBandit}}

Policy subclass examples: \code{\link{EpsilonGreedyPolicy}}, \code{\link{ContextualThompsonSamplingPolicy}}
}
