% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-xts.R
\name{opts_xts}
\alias{opts_xts}
\title{Constructive options for class 'xts'}
\usage{
opts_xts(constructor = c("as.xts.matrix", "next"), ...)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the object.}

\item{...}{Additional options used by user defined constructors through the \code{opts} object}
}
\value{
An object of class <constructive_options/constructive_options_xts>
}
\description{
These options will be used on objects of class 'xts'.
}
\details{
Depending on \code{constructor}, we construct the object as follows:
\itemize{
\item \code{"as.xts.matrix"} (default): We build the object using \code{xts::as.xts.matrix()}.
\item \code{"as.xts.data.frame"}: We build the object using \code{xts::as.xts.data.frame()},
this is probably the most readable option but couldn't be made the default
constructor because it requires the 'xts' package to be installed .
\item \code{"xts"}: We build the object using \code{xts::xts()}.
\item \code{".xts"}: We build the object using \code{xts::.xts()}.
\item \code{"next"}: Use the constructor for the next supported class.
}
}
