% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-ggplot2-Layer.R
\name{opts_Layer}
\alias{opts_Layer}
\title{Constructive options for class 'Layer' (ggplot2)}
\usage{
opts_Layer(constructor = c("default", "layer", "next", "environment"), ...)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the object, see Details section.}

\item{...}{Additional options used by user defined constructors through the \code{opts} object}
}
\value{
An object of class <constructive_options/constructive_options_Layer>
}
\description{
These options will be used on objects of class 'Layer'.
}
\details{
Depending on \code{constructor}, we construct the object as follows:
\itemize{
\item \code{"default"} : We attempt to use the function originally used to create the
plot.
\item \code{"layer"} : We use the \code{ggplot2::layer()} function
\item \code{"environment"} : Reconstruct the object using the general environment method
(which can be itself tweaked using \code{opts_environment()})
}

The latter constructor is the only one that reproduces the object exactly
since Layers are environments and environments can't be exactly copied (see \code{?opts_environment})
}
