% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-function.R
\name{opts_function}
\alias{opts_function}
\title{Constructive options for functions}
\usage{
opts_function(
  constructor = c("function", "as.function", "new_function"),
  ...,
  environment = TRUE,
  srcref = FALSE,
  trim = NULL
)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the environment, see Details section.}

\item{...}{Should not be used. Forces passing arguments by name.}

\item{environment}{Boolean. Whether to reconstruct the function's environment.}

\item{srcref}{Boolean. Whether to attempt to reconstruct the function's srcref.}

\item{trim}{\code{NULL} or integerish. Maximum of lines showed in the body before it's trimmed,
replacing code with \code{...}. Note that it will necessarily produce code that doesn't
reproduce the input, but it will parse and evaluate without failure.}
}
\value{
An object of class <constructive_options/constructive_options_function>
}
\description{
These options will be used on functions, i.e. objects of type "closure", "special" and "builtin".
}
\details{
Depending on \code{constructor}, we construct the environment as follows:
\itemize{
\item \code{"function"} (default): Build the object using a standard \code{function() {}}
definition. This won't set the environment by default, unless \code{environment}
is set to \code{TRUE}. If a srcref is available, if this srcref matches the function's
definition, and if \code{trim} is left \code{NULL}, the code is returned from using the srcref,
so comments will be shown in the output of \code{construct()}. In the rare case
where the ast body of the function contains non syntactic nodes this constructor
cannot be used and falls back to the \code{"as.function"} constructor.
\item \code{"as.function"} : Build the object using a \code{as.function()} call.
back to \code{data.frame()}.
\item \code{"new_function"} : Build the object using a \code{rlang::new_function()} call.
}
}
