% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deparse_call.R
\name{deparse_call}
\alias{deparse_call}
\title{Deparse a language object}
\usage{
deparse_call(
  call,
  one_liner = FALSE,
  pipe = FALSE,
  style = TRUE,
  collapse = !style
)
}
\arguments{
\item{call}{A call}

\item{one_liner}{Boolean. Whether to collapse multi-line expressions on a single line using
semicolons}

\item{pipe}{Boolean. Whether to use the base pipe to disentangle nested calls. This
works best on simple calls.}

\item{style}{Boolean. Whether to give a class "constructive_code" on the output
for pretty printing.}

\item{collapse}{Boolean. Whether to collapse the output to a single string,
won't be directly visible if \code{style} is \code{TRUE}}
}
\value{
a string or a character vector, with a class "constructive_code" for pretty
printing if \code{style} is \code{TRUE}
}
\description{
This is an alternative to \code{base::deparse()} and \code{rlang::expr_deparse()} that
handles additional corner cases and fails when encountering tokens other than
symbols and syntactic literals where cited alternatives would produce non syntactic code.\cr\cr
}
\examples{
expr <- quote(foo(bar({this; that}, 1)))
deparse_call(expr)
deparse_call(expr, one_liner = TRUE)
deparse_call(expr, pipe = TRUE)
deparse_call(expr, style = FALSE)
# some corner cases are handled better than in base R
deparse(call("$", 1, 1)) # returns non syntactic output
deparse_call(call("$", 1, 1))
}
