% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_voice.R
\name{ms_choose_voice}
\alias{ms_choose_voice}
\title{Provide default voice when not provided}
\usage{
ms_choose_voice(
  api_key = NULL,
  gender = c("Female", "Male"),
  language = "en-US",
  region = "westus"
)
}
\arguments{
\item{api_key}{Microsoft Azure Cognitive Services API key}

\item{gender}{Sex of speaker}

\item{language}{Language to be spoken}

\item{region}{Subscription region for API key. For more info, see
\url{https://learn.microsoft.com/en-us/azure/cognitive-services/speech-service/regions}}
}
\value{
List of gender, language, and full voice name
}
\description{
If 'voice' argument is not supplied to \code{ms_synthesize()}, obtain full list of voices for
a specified region and by default, use the first voice in that list.
}
\examples{
\dontrun{
# Default voice whose gender is Female, language is English, and region is 'westus'
ms_choose_voice(gender = "Female", language = "en-US", region = "westus")
}
}
