% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateHelpers.R
\name{genItems}
\alias{genItems}
\title{genItems}
\usage{
genItems(n, scores = NULL, deltadots, taus = NULL, discrims = 1)
}
\arguments{
\item{n}{How many items?}

\item{scores}{When NULL it is assumed that all items have
integer scoring, increasing for each category k, and beginning from 0.
Otherwise a list where the elements are, in order:
\itemize{
\item a string naming a distribution function (for example \code{runif}, \code{rnorm}) to generate random deviates
from (the scores).
\item a list of parameters to pass to the distribution function (for example, for \code{runif}, a list of
length 2 defining "min" and "max"). This list is assumed to be in order to be directly passed into
the function.
\item a boolean indicating whether the scores should be forced to be increasing across the response
categories.
\item optionally a vector of item numbers to apply scores too. If not provided it is assumed that all items
will be scored.
}}

\item{deltadots}{A list where the elements are, in order:
\itemize{
\item a string naming a distribution function (for example \code{runif}, \code{rnorm}) to generate random deviates
from (the delta dots).
\item a list of parameters to pass to the distribution function (for example, for \code{runif}, a list of
length 2 defining "min" and "max"). This list is assumed to be in order to be directly passed into
the function.
}}

\item{taus}{When NULL all items are assumed to be dichotomies.
Otherwise a list where the elements are, in order:
\itemize{
\item a string naming a distribution function (for example \code{runif}, \code{rnorm}) to generate random deviates
from (the taus).
Or the string "manual" to indicate that a user-defined list of the tau parameters will be
provided.
\item a list of parameters to pass to the distribution function (for example, for \code{runif}, a list of
length 2 defining "min" and "max"). This list is assumed to be in order to be directly passed into
the function. if the first element in \code{taus} is "manual" this should be a list of taus to be used
this must be of the correct dimensions - for example, if there are 2 polytomous items being generated,
each with 3 response categories (k), then the list should be of length 2: 2 * (k-  2) =  2 * (3 - 2) =
2 taus. This is because there are k-1 taus per item, and the last tau is always constrained to be the negative
sum of the rest for identification purposes.
\item a Boolean indicating whether the taus should be forced to be increasing across the response
category boundaries (that is, enforce that no item exhibits disordered thresholds).
\item optionally a vector of item numbers to produce taus for. If not provided it is assumed that all items
are polytomous.
\item optionally a vector of response categories to apply to each item. For example if the user indicates that
5 items are polytomous, then a vector of length 5 where the first elements describes the count of response
categories for the first polytomous item, the second element describes the count of response
categories for the second polytomous item, and so on
}}

\item{discrims}{When NULL all items are assumed to have constant discrimination equal to 1.
Otherwise a list where the elements are, in order:
\itemize{
\item a string naming a distribution function (for example \code{runif}, \code{rnorm}) to generate random deviates
from (the discriminations).
Or the string "manual" to indicate that a user-defined list of the discrimination parameters will be
provided.
\item a list of parameters to pass to the distribution function (for example, for \code{runif}, a list of
length 2 defining "min" and "max"). This list is assumed to be in order to be directly passed into
the function.
\item a Boolean indicating whether the discriminations are constant within items or whether each response category
within an item will have its own score should be forced to be increasing across the response
category boundaries (that is, this can be one way of specifying the Bock Nominal model).
\item optionally a vector of items to apply a unique discrimination to. Otherwise it is assumed that all items
have unique discriminations.
}}
}
\value{
A list of item matrices.
}
\description{
Generates a list of item parameter matrices for use in
function like \code{conquestr::genResponses} and \code{conquestr::informationWrightMap}
}
\examples{
  myItem <- matrix(c(0, 0, 0, 0, 1, 1, 0, 1), ncol = 4, byrow = TRUE)
  myItems <- list(myItem, myItem)
  myItems[[2]][2, 2] <- -1 # make the second item delta equal to -1
  myResponses <- genResponses(abilities = rnorm(100), itemParams = myItems)
}
\seealso{
\code{\link[=simplef]{simplef()}}, \link{genResponses}, \code{browseVignettes("conquestr")}
}
